
local function line(header, c)
    header = header or ''
    c = c or '-'
    print(string.rep(string.sub(c, 1, 1), 78 - string.len(header))..header)
end

local function ipart(value)
    return value - math.mod(value, 1)
end

local function bitvalues(value, bstart, num)
    value = ipart(value / 2^bstart)
    return math.mod(value, 2^num)
end

line(' zlib '..zlib.version(), '=')

line(' compile options')

local function bits(bv)
    if (bv == 0) then
        bv = 16
    elseif (bv == 1) then
        bv = 32
    elseif (bv == 10) then
        bv = 64
    else
        bv = 'other'
    end
    return bv
end

local co = zlib.compile_flags()
local v

print('uInt size   : '..bits(bitvalues(co, 0, 2))..' bits')
print('uLong size  : '..bits(bitvalues(co, 2, 2))..' bits')
print('voidpf size : '..bits(bitvalues(co, 4, 2))..' bits')
print('z_off_t size: '..bits(bitvalues(co, 6, 2))..' bits')

v = ''
if (bitvalues(co, 8, 1) == 1) then v = v..' DEBUG' end
if (bitvalues(co, 9, 1) == 1) then v = v..' ASMV' end
if (bitvalues(co, 10, 1) == 1) then v = v..' ZLIB_WINAPI' end
if (string.len(v) == 0) then v = '(none)' else v = string.sub(v, 2) end
print('Compiler, assembler and debug options: '..v)

v = ''
if (bitvalues(co, 12, 1) == 1) then v = v..' BUILDFIXED' end
if (bitvalues(co, 13, 1) == 1) then v = v..' DYNAMIC_CRC_TABLE' end
if (string.len(v) == 0) then v = '(none)' else v = string.sub(v, 2) end
print('One-time table building              : '..v)

v = ''
if (bitvalues(co, 16, 1) == 1) then v = v..' NO_GZCOMPRESS' end
if (bitvalues(co, 17, 1) == 1) then v = v..' NO_GZIP' end
if (string.len(v) == 0) then v = '(none)' else v = string.sub(v, 2) end
print('Library content                      : '..v)

v = ''
if (bitvalues(co, 20, 1) == 1) then v = v..' PKZIP_BUG_WORKAROUND' end
if (bitvalues(co, 21, 1) == 1) then v = v..' FASTEST' end
if (string.len(v) == 0) then v = '(none)' else v = string.sub(v, 2) end
print('Operation variations                 : '..v)

if (bitvalues(co, 24, 1) == 0) then v = 'vs' else v = 's' end
if (bitvalues(co, 25, 1) == 0) then v = v..'nprintf' else v = v..'printf' end
if (bitvalues(co, 26, 1) == 0) then v = v..' (returns value)' else v = v..' (returns void)' end
print('sprintf variant used by gzprintf     : '..v)

line(' adler32')
local adler = zlib.adler32()
print('adler32 initial value: '..adler)
adler = zlib.adler32(adler, 'some text')
print('updated adler        : '..adler)
adler = zlib.adler32(adler, 'some text')
print('updated adler        : '..adler)
adler = zlib.adler32(adler, 'some text')
print('updated adler        : '..adler)
adler = zlib.adler32(adler, 'some text')
print('updated adler        : '..adler)
adler = zlib.adler32(adler, 'some text')
print('updated adler        : '..adler)
adler = zlib.adler32(adler, 'some textd')
print('updated adler        : '..adler)

line(' crc32')
local crc = zlib.crc32()
print('crc32 initial value: '..crc)
crc = zlib.crc32(crc, 'some text')
print('updated crc        : '..crc)
crc = zlib.crc32(crc, 'some text')
print('updated crc        : '..crc)
crc = zlib.crc32(crc, 'some text')
print('updated crc        : '..crc)
crc = zlib.crc32(crc, 'some text')
print('updated crc        : '..crc)
crc = zlib.crc32(crc, 'some text')
print('updated crc        : '..crc)
crc = zlib.crc32(crc, 'some textd')
print('updated crc        : '..crc)


line(' deflate/inflate')
local us
f = io.open('lzlib.c') -- f = io.open('../all.tar')
us = f:read('*a')
f:close()

do -- local block

local f, cs, zd, zi, aux_res, res, ret, count
--local dict = 'woiefjwoeifjwoeifjweeeeeeeeeeeeeeeeeeeeeeeeeee'

print('file length              : '..string.len(us))

cs = ''
zd = zlib.deflate_init(1)
print('deflate stream           : '..tostring(zd))
zd:callback(function(b) cs = cs..b end)
if (dict and string.len(dict) > 0) then zd:set_dictionary(dict) end

zd:process(string.sub(us, 1, string.len(us)/2))
zd:params(9, zlib.DEFAULT_STRATEGY)
zd:process(string.sub(us, string.len(us)/2+1))
zd:process('', zlib.FINISH)

print('compressed length        : '..string.len(cs))
print('compressed adler         : '..tostring(zd:adler()))
zd:done()

zi = zlib.inflate_init()
print('inflate stream           : '..tostring(zi))
res = ''
zi:callback(function(b) res = res..b end)
zi:dictionary(function() zi:set_dictionary(dict) end)
ret, count = zi:process(string.sub(cs, 1, 10))
zi:process(string.sub(cs, count+1))
zi:process('', zlib.FINISH)
print('uncompressed length      : '..string.len(res))
print('uncompressed adler       : '..tostring(zi:adler()))
zi:done()
print('result == uncompressed   : '..tostring(res == us))
print('compression ratio        : '..tostring(string.len(us)/string.len(cs)))

end -- local block
collectgarbage()

line(' compress/uncompress')
do -- local block
local cs, res
print('file length              : '..string.len(us))
cs = zlib.compress(us,1)
print('compressed length        : '..string.len(cs))
res = zlib.uncompress(cs)
print('compressed length        : '..string.len(res))
print('result == uncompressed   : '..tostring(res == us))
print('compression ratio        : '..tostring(string.len(us)/string.len(cs)))
end -- local block

line(' zlib '..zlib.version(), '=')
