require('requirelib')

local app = requirelib('lgraphapp', 'luaopen_graphapp')()
local ustring = requirelib('lustring', 'luaopen_ustring')()
ustring.setlocale('en_US.UTF-8')

pcall(loadlib)

local function line(header, c)
    header = header or ''
    c = c or '-'
    io.write(string.rep(string.sub(c, 1, 1), 78 - string.len(header)), header, '\n')
end

line(' GraphApp')
print("graphapp: "..tostring(app))
print("gui available: "..tostring(app:gui_available()))

--[[
line(' clipboard')
print(app:get_clipboard_text())
print(app:set_clipboard_text('hello world'))
print(app:get_clipboard_text())
--]]

line(' point')

local p1 = app:Point(1, 4)
print(p1)
p1.x = 3
print(p1.x)
local p2 = app:Point(100, -3)
print(p2)
print(-p1)
print(p1+p2)
print(p1 - p2)


line(' rect')

local r1 = app:Rect(0, 0, 200, 150)
local r2 = app:Rect(0, 0, 200, 150)
print(tostring(r1)..' == '..tostring(r2)..' -> '..tostring(r1 == r2))

local r3 = app:Rect(5, 10, 400, 100)
print(r3)
local r4 = r1:clip_rect(r3)
print(r1, r3, r4)

line(' font')
print(app:find_default_font())

line(' image')
local img = app:Image(32, 32, 8)
print(img)
local cmap = img:get_cmap()
print(cmap and unpack(cmap))
img:set_cmap{app:Colour(1, 1, 1), app:Colour(200, 2, 2)}
cmap = img:get_cmap()
print(unpack(cmap))

line(' creating gui')

local win = app:Window(r1, 'name', app.STANDARD_WINDOW + app.CENTERED)
local icon = app:Image(32, 32, 8)
icon:set_cmap{app:Colour(255, 255, 255, 255), app:Colour(255, 255, 0), app:Colour(0,0,255), app:Colour(0,0,0)}
local g = icon:get_graphics()
print(g:get_area())
g:set_rgb(app:Colour(0, 0, 0))
g:fill_rect(app:Rect(0, 0, 31, 31))
g:set_rgb(app:Colour(255, 255, 255, 255))
g:draw_point(app:Point(1, 1))
g:set_rgb(app:Colour(0, 0, 255))
g:draw_line(app:Point(0, 0), app:Point(31, 31))
g:draw_line(app:Point(0, 31), app:Point(31, 0))

win:set_icon(icon)
local imglabel = win:ImageLabel(app:Rect(10, 60, 80, 30), icon, app.ALIGN_RIGHT + app.VALIGN_BOTTOM)
--[[
local button = win:Button(app:Rect(10, 100, 32, 32), 'hello', function (c)
    app:ask_ok("title", "hello!")
end)
--]]
---[[
local imgbutton = win:ImageButton(app:Rect(10, 100, 32, 32), icon, function (c)
    app:beep()
    app:ask_ok("title", "hello!")
end)
--]]
local label = win:Label(app:Rect(10, 10, 80, 30), 'monhe', app.ALIGN_RIGHT + app.VALIGN_BOTTOM)
label:set_background(app:Colour(0, 255, 255))

label:set_image(img)

g:delete()
icon:delete()

print(win, label, imglabel)

win:on_deletion(function(window)
    print('deleted window: '..tostring(win))
end)

--[[
win:on_move(function(w)
    print('moved window: '..tostring(w))
end)
--]]

win:on_redraw(function(w, g)
    g:set_rgb(app:Colour(255, 0, 0, 10))
    for i = 1, 10 do
        g:draw_utf8(app:Point(i*10, i*20), "hello world!!!")
    end
    g:set_rgb(app:Colour(0, 255, 0, 100))
    for i = 1, 10 do
        g:draw_utf8(app:Point(i*10+1, i*20), "hello world!!!")
    end
end)

win:on_mouse_down(function(w, buttons, point)
    local list = { "yes", "no" }
    local r = w:pop_up_list(app:find_default_font(), point, buttons, list)
    app:ask_ok('Choice', 'You choose '..tostring(list[r+1]))
end)
--[[
line(' timer')

local i = 0
local t = app:new_timer(1000, function()
    print('hi')
    i = i + 1
    if (i > 10) then
        print('goodbye')
        --app:del_timer(t)
    end
end)
--]]

line(' running')

--[[
win:show()
app:main_loop()
--]]

local function p(...)
    local s = ''
    for _,i in ipairs(arg) do
        if (string.len(s) > 0) then
            s = s..' '
        end
        s = s..tostring(i)
    end
    return s
end

---[[
local cstr = 'a'
while true do
    cstr = app:ask_string('string', 'str:', cstr)
    if (not cstr) then
        break
    end
    local str = ustring.new(cstr)
    for i = 1, str:len() do
        if (i > 1) then io.write(',') end
        io.write(str:byte(i))
    end
    io.write('\n')

    app:ask_ok('string',
        'string entrada com '..str:len()..' caracteres ['..tostring(str)..']\n' ..
        'lower: '..str:lower():cstr()..'\n'..
        'upper: '..str:upper():cstr()..'\n'..
        'find: '..p(str:find('(%w+)'))
    )
end
--]]
line(' done')

app:close()

line(' GraphApp')
